import 'dart:convert';

import 'package:get/get.dart';
import 'package:play_lab/constants/my_strings.dart';
import 'package:play_lab/core/helper/string_format_helper.dart';
import 'package:play_lab/core/utils/url_container.dart';
import 'package:play_lab/data/model/genres/genres_response_model.dart';
import 'package:play_lab/data/model/global/response_model/response_model.dart';
import 'package:play_lab/data/repo/genres/genres_repo.dart';
import 'package:play_lab/view/components/show_custom_snackbar.dart';

class GenresController extends GetxController {
  GenresRepo repo;
  GenresController({required this.repo});

  List<GenresCategory> genres = [];

  String landscapePath = "";
  String portraitPath = "";

  bool isLoading = false;
  Future<void> getDashBoardData() async {
    isLoading = true;
    update();
    try {
      ResponseModel model = await repo.getGenresData();

      if (model.statusCode == 200) {
        GenreResponseModel responseModel = GenreResponseModel.fromJson(jsonDecode(model.responseJson));
        if (responseModel.data != null) {
          genres = responseModel.data?.genres?.categories ?? [];
          landscapePath = "${UrlContainer.baseUrl}/${responseModel.data?.landscapePath}";
          portraitPath = "${UrlContainer.baseUrl}/${responseModel.data?.portraitPath}";
          update();
        } else {
          CustomSnackbar.showCustomSnackbar(errorList: responseModel.message?.error ?? [MyStrings.somethingWentWrong], msg: [], isError: true);
        }
      } else {
        CustomSnackbar.showCustomSnackbar(errorList: [model.message], msg: [], isError: true);
      }
    } catch (e) {
      printX(e.toString());
    }
    isLoading = false;
    update();
  }
}
